/*
 * Decompiled with CFR 0.152.
 */
package cryptography_demo;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SHA1
extends JFrame {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;

    public static byte[] getSHA(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String toHexString(byte[] hash) {
        BigInteger number = new BigInteger(1, hash);
        StringBuilder hexString = new StringBuilder(number.toString(16));
        while (hexString.length() < 64) {
            hexString.insert(0, '0');
        }
        return hexString.toString();
    }

    public SHA1() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.jLabel1.setText("Original Text");
        this.getContentPane().add((Component)this.jLabel1, new AbsoluteConstraints(39, 36, 136, -1));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.getContentPane().add((Component)this.jScrollPane1, new AbsoluteConstraints(260, 30, 300, 100));
        this.jLabel2.setText("Encypted Text");
        this.getContentPane().add((Component)this.jLabel2, new AbsoluteConstraints(50, 190, 180, -1));
        this.jButton1.setText("Encrypt");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SHA1.this.jButton1ActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButton1, new AbsoluteConstraints(210, 280, -1, -1));
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea2);
        this.getContentPane().add((Component)this.jScrollPane2, new AbsoluteConstraints(260, 160, 290, 80));
        this.jButton2.setText("Reset");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SHA1.this.jButton2ActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButton2, new AbsoluteConstraints(300, 280, -1, -1));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            String str1 = this.jTextArea1.getText();
            String str2 = SHA1.toHexString(SHA1.getSHA(str1));
            this.jTextArea2.setText(str2);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("The Exception for wrong hashing algorithm: " + String.valueOf(e));
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jTextArea1.setText("");
        this.jTextArea2.setText("");
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SHA1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SHA1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SHA1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SHA1.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SHA1().setVisible(true);
            }
        });
    }
}

